//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
// StringHeapPage.cpp : plik implementacji
//

#include "stdafx.h"
#include "AssemblyDoc.h"
#include "AssemblyView.h"
#include "StringHeapPage.h"


// Okno dialogowe CStringHeapPage

IMPLEMENT_DYNAMIC(CStringHeapPage, CPropertyPage)
CStringHeapPage::CStringHeapPage()
	: CPropertyPage(CStringHeapPage::IDD)
{
}

CStringHeapPage::~CStringHeapPage()
{
}

void CStringHeapPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_STRINGLIST, m_ctrlStringList);
}


BEGIN_MESSAGE_MAP(CStringHeapPage, CPropertyPage)
END_MESSAGE_MAP()


// Procedury obsugi wiadomoci CStringHeapPage

void CStringHeapPage::DumpString(
    CListCtrl   *pList,			  // Sterowanie list, do ktrej s przekazywane dane
    ULONG       cRows,            // Numer cigu.
    ULONG       oData,            // Indeks danych.
    const char  *psData)          // Dane do wywietlenia.
{
	ULONG itemIndex;
	TCHAR cBuffer[64];
	LPWSTR lpszBuffer;

	itemIndex = pList->GetItemCount();
	memset(cBuffer, 0, sizeof(cBuffer));

    wsprintf(cBuffer, _T("%d"), cRows);
	itemIndex = pList->InsertItem(itemIndex, cBuffer);

    wsprintf(cBuffer, _T("%d(0x%02x)"), oData, oData);
	pList->SetItemText(itemIndex, 1, cBuffer);

	lpszBuffer = (LPWSTR)_alloca((strlen(psData) + 1) * sizeof(wchar_t));
	mbstowcs(lpszBuffer, psData, strlen(psData) + 1);
    pList->SetItemText(itemIndex, 2, lpszBuffer);

    return;
}

BOOL CStringHeapPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	CString strItemLabel = _T("Item");
	CString strIndex = _T("Index");
	CString strString = _T("String");

	CRect rect;
	// Wstawienie trzech kolumn (tryb raportu) i modyfikacja nowych elementw nagwka
	m_ctrlStringList.GetWindowRect(&rect);
	m_ctrlStringList.InsertColumn(0, strItemLabel, LVCFMT_LEFT,
		                        rect.Width() * 1/6, 0);
	m_ctrlStringList.InsertColumn(1, strIndex, LVCFMT_LEFT,
		                        rect.Width() * 1/6, 1);
	m_ctrlStringList.InsertColumn(2, strString, LVCFMT_LEFT,
		                        rect.Width() * 2/3, 2);

	// Wypenienie danymi
	CPropertySheet *pPropertySheet = STATIC_DOWNCAST(CPropertySheet, GetParent());
	CAssemblyView* pView = STATIC_DOWNCAST(CAssemblyView, pPropertySheet->GetParent());

	// Wskanik cigu.
	const char *pString = (const char *)pView->StringTable();
	DWORD stringsTableSize = pView->StringTableSize();
	// Przesunicie biecego cigu.
    ULONG oData;
	ULONG cRows;
    oData = 0;
	cRows = 0;
    do 
    {
        if (*(pString + oData) != 0)
		{
			DumpString(&m_ctrlStringList, cRows, oData, pString + oData);
		}
        oData += (ULONG)strlen(pString + oData) + 1;
		cRows++;
    }
    while (oData < stringsTableSize);

	return TRUE;  // zwrcenie TRUE, chyba e ognisko ustawiono na element sterujcy
}
